let scraping = false;
let lastScrapedName = null;

// --- RECTIFIED CODE: Remove "return true" as no response is sent ---
chrome.runtime.onMessage.addListener((request, sender) => {
    if (request.command === 'start-scraping') {
        if (!scraping) {
            scraping = true;
            startScraping();
        }
    } else if (request.command === 'stop-scraping') {
        scraping = false;
    }
    // No "return true;" because we are not calling sendResponse().
});


// Helper function for introducing delays
const delay = ms => new Promise(res => setTimeout(res, ms));

// Helper function to wait for an element to appear/update
const waitForDataChange = async (selector, previousValue) => {
    return new Promise((resolve, reject) => {
        const timeout = 10000; // 10 second timeout
        const interval = 500; // Check every 500ms
        let elapsedTime = 0;

        const intervalId = setInterval(() => {
            elapsedTime += interval;
            const element = document.querySelector(selector);
            // Resolve if element is found AND its content is new
            if (element && element.textContent.trim() !== previousValue) {
                clearInterval(intervalId);
                resolve(element);
            } else if (elapsedTime >= timeout) {
                clearInterval(intervalId);
                console.warn(`waitForDataChange timed out for selector: ${selector}`);
                reject(new Error(`Timeout waiting for selector: ${selector}`));
            }
        }, interval);
    });
};


async function startScraping() {
    console.log('Scraping started...');

    const scrollablePanelSelector = 'div[role="feed"]';
    
    while (scraping) {
        const scrollablePanel = document.querySelector(scrollablePanelSelector);
        if (!scrollablePanel) {
            console.error("Scrollable panel not found.");
            chrome.runtime.sendMessage({ command: 'finished' });
            break;
        }

        const resultItems = Array.from(scrollablePanel.querySelectorAll('a.hfpxzc:not([data-scraped="true"])'));

        if (resultItems.length === 0) {
            console.log("No new results found, scrolling down...");
            // Check for the "end of list" marker
            const endOfListMarker = scrollablePanel.querySelector('.HlvSq');
            if(endOfListMarker) {
                console.log("Google Maps says: 'You've reached the end of the list.'");
                chrome.runtime.sendMessage({ command: 'finished' });
                scraping = false;
                break;
            }

            scrollablePanel.scrollTop = scrollablePanel.scrollHeight;
            await delay(3000 + Math.random() * 2000);

            const newItems = scrollablePanel.querySelectorAll('a.hfpxzc:not([data-scraped="true"])');
            if (newItems.length === 0 && !scraping) { // Re-check scraping status after delay
                break; // Exit if stopped during the delay
            }
            if (newItems.length === 0) {
                console.log("Still no new results after scroll. Assuming end of list.");
                chrome.runtime.sendMessage({ command: 'finished' });
                scraping = false;
                break;
            }
            continue;
        }

        for (const item of resultItems) {
            if (!scraping) break;
            
            // Scroll the item into view before clicking to be more human-like
            item.scrollIntoView({ behavior: 'smooth', block: 'center' });
            await delay(300 + Math.random() * 300);

            item.click();

            try {
                await waitForDataChange('h1.DUwDvf', lastScrapedName);
            } catch (error) {
                console.error(error.message);
                console.log("Skipping item due to timeout. It might be an ad or an invalid entry.");
                item.setAttribute('data-scraped', 'true'); // Mark it to avoid getting stuck
                continue;
            }
            await delay(500 + Math.random() * 1000);

            const name = document.querySelector('h1.DUwDvf')?.textContent.trim() || 'N/A';
            lastScrapedName = name;

            const ratingText = document.querySelector('div.F7nice > span > span[aria-hidden="true"]')?.textContent.trim() || 'N/A';
            const reviewsCountText = document.querySelector('div.F7nice > span:last-child')?.textContent.trim().replace(/[(),]/g, '') || '0';
            
            const address = document.querySelector('button[data-item-id*="address"] div.AeaXub div.rogA2c')?.textContent.trim() || 'N/A';
            const phone = document.querySelector('button[data-item-id*="phone"] div.AeaXub div.rogA2c')?.textContent.trim() || 'N/A';

            const website = document.querySelector('a[data-item-id="authority"]')?.getAttribute('href') || 'N/A';

            const businessObject = {
                'Name': name,
                'Address': address,
                'Phone': phone,
                'Website': website, 
                'Rating': ratingText,
                'Reviews': reviewsCountText,
            };

            console.log('Scraped:', businessObject);
            chrome.runtime.sendMessage({ command: 'data', data: businessObject });

            item.setAttribute('data-scraped', 'true');

            await delay(800 + Math.random() * 1500);
        }
    }
    if (!scraping) {
        console.log("Scraping loop stopped.");
    }
}