document.addEventListener('DOMContentLoaded', () => {
    const startBtn = document.getElementById('startScrapingBtn');
    const stopBtn = document.getElementById('stopScrapingBtn');
    const statusEl = document.getElementById('status');

    // Set initial button states based on stored state
    chrome.storage.local.get(['isScraping'], (result) => {
        if (result.isScraping) {
            startBtn.disabled = true;
            stopBtn.disabled = false;
            statusEl.textContent = 'Scraping is active...';
        } else {
            startBtn.disabled = false;
            stopBtn.disabled = true;
            statusEl.textContent = 'Idle';
        }
    });

    startBtn.addEventListener('click', () => {
        chrome.runtime.sendMessage({ command: 'start' });
        startBtn.disabled = true;
        stopBtn.disabled = false;
        statusEl.textContent = 'Initializing...';
    });

    stopBtn.addEventListener('click', () => {
        chrome.runtime.sendMessage({ command: 'stop' });
        startBtn.disabled = true;
        stopBtn.disabled = true;
        statusEl.textContent = 'Stopping...';
    });
    
    // Listen for status updates from background or content script
    chrome.runtime.onMessage.addListener((request) => {
        if (request.command === 'updateStatus') {
            statusEl.textContent = request.text;
            if (request.finished) {
                startBtn.disabled = false;
                stopBtn.disabled = true;
            }
        }
    });
});